/*
 * Decompiled with CFR 0.152.
 */
package icommand.platform.nxt;

import icommand.nxtcomm.FileInfo;
import icommand.nxtcomm.NXTCommand;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class FileSystem {
    private FileSystem() {
    }

    public static byte upload(File file) {
        byte[] byArray;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("File read didn't work");
            iOException.printStackTrace();
            return -1;
        }
        byte by = NXTCommand.openWrite(file.getName(), byArray.length);
        byte by2 = NXTCommand.writeFile(by, byArray);
        NXTCommand.closeFile(by);
        return by2;
    }

    public static byte[] download(String string) {
        FileInfo fileInfo = NXTCommand.openRead(string);
        if (fileInfo.status != 0) {
            byte[] byArray = new byte[]{fileInfo.status};
            return byArray;
        }
        byte[] byArray = NXTCommand.readFile(fileInfo.fileHandle, fileInfo.fileSize);
        NXTCommand.closeFile(fileInfo.fileHandle);
        return byArray;
    }

    public static byte download(String string, File file) {
        byte[] byArray = FileSystem.download(string);
        File file2 = file.isDirectory() ? new File(file.toString() + File.separator + string) : file;
        try {
            if (file2.createNewFile()) {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                fileOutputStream.write(byArray);
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            System.out.println("File write didn't work");
            iOException.printStackTrace();
            return -1;
        }
        return 0;
    }

    public static byte download(String string, String string2) {
        File file = new File(string2);
        return FileSystem.download(string, file);
    }

    public static byte delete(String string) {
        return NXTCommand.delete(string);
    }

    public static String[] getFileNames() {
        return FileSystem.getFileNames("*.*");
    }

    public static String[] getFileNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        FileInfo fileInfo = NXTCommand.findFirst(string);
        if (fileInfo == null) {
            return null;
        }
        do {
            arrayList.add(fileInfo.fileName);
            if (fileInfo == null) continue;
            NXTCommand.closeFile(fileInfo.fileHandle);
        } while ((fileInfo = NXTCommand.findNext(fileInfo.fileHandle)) != null);
        String[] stringArray = new String[1];
        return arrayList.toArray(stringArray);
    }

    public static String getCurrentProgramName() {
        return NXTCommand.getCurrentProgramName();
    }

    public static byte startProgram(String string) {
        return NXTCommand.startProgram(string);
    }

    public static byte stopProgram() {
        return NXTCommand.stopProgram();
    }
}

