/*
 * Decompiled with CFR 0.152.
 */
package icommand.platform.nxt;

import icommand.nxtcomm.NXTCommand;
import icommand.nxtcomm.NXTProtocol;
import icommand.nxtcomm.OutputState;

public class Motor
implements NXTProtocol {
    private int id;
    private byte power;
    private int mode;
    private int regulationMode;
    protected byte turnRatio;
    private int runState;
    public static final Motor A = new Motor(0);
    public static final Motor B = new Motor(1);
    public static final Motor C = new Motor(2);

    private Motor(int n) {
        this.id = n;
        this.power = (byte)80;
        this.mode = 6;
        this.regulationMode = 1;
        this.turnRatio = 0;
        this.runState = 0;
    }

    public final char getId() {
        char c = 'A';
        switch (this.id) {
            case 0: {
                c = 'A';
                break;
            }
            case 1: {
                c = 'B';
                break;
            }
            case 2: {
                c = 'C';
            }
        }
        return c;
    }

    public int forward() {
        this.runState = 32;
        return NXTCommand.setOutputState(this.id, this.power, this.mode + 1, this.regulationMode, this.turnRatio, this.runState, 0);
    }

    public int backward() {
        this.runState = 32;
        return NXTCommand.setOutputState(this.id, -this.power, this.mode + 1, this.regulationMode, this.turnRatio, this.runState, 0);
    }

    public void setSpeed(int n) {
        if (n > 100 | n < -100) {
            return;
        }
        this.power = (byte)n;
    }

    public int getTacho() {
        OutputState outputState = NXTCommand.getOutputState(this.id);
        return outputState.tachoCount;
    }

    public int getRotationCount() {
        OutputState outputState = NXTCommand.getOutputState(this.id);
        return outputState.rotationCount;
    }

    public int getBlockTacho() {
        OutputState outputState = NXTCommand.getOutputState(this.id);
        return outputState.blockTachoCount;
    }

    public int forward(long l, boolean bl) {
        if (!bl) {
            return this.forward(l);
        }
        byte by = NXTCommand.setOutputState(this.id, (byte)1, 7, this.regulationMode, this.turnRatio, 32, 0);
        by = NXTCommand.setOutputState(this.id, this.power, 7, this.regulationMode, this.turnRatio, 16, (int)l);
        return by;
    }

    public int forward(long l) {
        int n;
        this.runState = 32;
        long l2 = (long)this.getTacho() + l;
        byte by = NXTCommand.setOutputState(this.id, this.power, this.mode + 1, this.regulationMode, this.turnRatio, this.runState, 0);
        while ((long)(n = this.getTacho()) < l2 - 15L) {
        }
        this.stop();
        return by;
    }

    public int backward(long l, boolean bl) {
        if (!bl) {
            return this.backward(l);
        }
        byte by = NXTCommand.setOutputState(this.id, (byte)1, this.mode + 1, this.regulationMode, this.turnRatio, 32, 0);
        by = NXTCommand.setOutputState(this.id, -this.power, this.mode + 1, this.regulationMode, this.turnRatio, 16, (int)l);
        return by;
    }

    public int backward(long l) {
        int n;
        this.runState = 32;
        long l2 = (long)this.getTacho() - l;
        byte by = NXTCommand.setOutputState(this.id, -this.power, this.mode + 1, this.regulationMode, this.turnRatio, this.runState, 0);
        while ((long)(n = this.getTacho()) > l2 + 15L) {
        }
        this.stop();
        return by;
    }

    public void setRegulationMode(int n) {
        this.regulationMode = n;
    }

    public int rotateTo(long l) {
        int n = this.getTacho();
        if (l > (long)n) {
            return this.forward(l - (long)n);
        }
        return this.backward((long)n - l);
    }

    public int rotateTo(long l, boolean bl) {
        if (!bl) {
            return this.rotateTo(l);
        }
        int n = this.getTacho();
        if (l > (long)n) {
            return this.forward(l - (long)n, bl);
        }
        return this.backward((long)n - l, bl);
    }

    public int resetRotationCounter() {
        return NXTCommand.resetMotorPosition(this.id, false);
    }

    public int resetBlockTacho() {
        return NXTCommand.resetMotorPosition(this.id, true);
    }

    public int stop() {
        this.runState = 32;
        return NXTCommand.setOutputState(this.id, (byte)0, 7, this.regulationMode, this.turnRatio, this.runState, 0);
    }

    public int flt() {
        this.runState = 0;
        this.mode = 0;
        return NXTCommand.setOutputState(this.id, (byte)0, 0, this.regulationMode, this.turnRatio, this.runState, 0);
    }
}

