/*
 * Decompiled with CFR 0.152.
 */
package icommand.vision;

import icommand.vision.ColorEffect;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.Control;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorDetectionControl
implements Control,
ActionListener,
ChangeListener {
    private Component component;
    private JButton button;
    private JSlider threshold;
    private JSlider proportionThreshold;
    private JLabel label;
    private JLabel proportionLabel;
    private ColorEffect effect;
    private boolean debug;

    public ColorDetectionControl(ColorEffect colorEffect) {
        this.effect = colorEffect;
    }

    public Component getControlComponent() {
        if (this.component == null) {
            this.label = new JLabel("Set Pixel difference threshold:");
            this.proportionLabel = new JLabel("Set Proportion threshold:");
            this.button = new JButton("Color Debug");
            this.button.addActionListener(this);
            this.button.setToolTipText("Click to turn debugging mode on/off");
            this.threshold = new JSlider(0, 0, 10, ColorEffect.pixelThreshold / 4);
            this.threshold.setMajorTickSpacing(1);
            this.threshold.setPaintLabels(true);
            this.threshold.addChangeListener(this);
            this.proportionThreshold = new JSlider(0, 0, 10, (int)(ColorEffect.requiredProportion / 0.05f));
            this.proportionThreshold.setMajorTickSpacing(1);
            this.proportionThreshold.setPaintLabels(true);
            this.proportionThreshold.addChangeListener(this);
            Box box = Box.createVerticalBox();
            box.add(this.label);
            box.add(this.threshold);
            box.add(this.proportionLabel);
            box.add(this.proportionThreshold);
            box.invalidate();
            this.component = box;
        }
        return this.component;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.button) {
            this.debug = !this.debug;
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.threshold) {
            ColorEffect.pixelThreshold = this.threshold.getValue() * 4;
        }
        if (object == this.proportionThreshold) {
            ColorEffect.requiredProportion = (float)this.proportionThreshold.getValue() * 0.05f;
        }
    }
}

