import icommand.platform.nxt.*;
import icommand.nxtcomm.*;
import icommand.robotics.*;

public class LightTest {

	public static void usage() {
		System.out.println("Usage:");
		System.out.println("  java LightTest <speed>");
		System.out.println("");
		System.out.println("     speed:     Integeger between 1 and 255");
	}

	public static void main(String[] args) {
		if(args.length < 1) {
			usage();
			return;
		}

		int speed = Integer.parseInt(args[0]);

		SyncMotors sm = new SyncMotors(Motor.C, Motor.B);
		sm.setSpeed(speed);
		sm.forward();

		Light l = new Light(Sensor.S3);

		int color = l.getLightPercent();
		long start = System.currentTimeMillis();
		for(int i=0; i<99; i++) {
			System.currentTimeMillis();
		}

		System.out.println("Für den Aufruf von 100x System.currentTimeMillis() benötigte Zeit: " + (System.currentTimeMillis() - start));

		System.out.println("Ab jetzt: Messung der Aufrufdauer von Licht.getLightPercent():");
		start = System.currentTimeMillis();
		while(color > 35) {
			color = l.getLightPercent();
			System.out.println("Benötigte Zeit: " + (System.currentTimeMillis()-start) + "ms, zurückgegebener Wert: " + color);
			start = System.currentTimeMillis();
		}

		sm.stop();

	        NXTCommand.close();
	}
}

