import icommand.platform.nxt.*;
import icommand.nxtcomm.*;
import icommand.robotics.*;


/*
 *  Wrapperklasse für ServoNavigator für einen Tribot:
 *
 *  Motor für die Klaue: Port A
 *  Motor linker Reifen: Port C
 *  Motor rechter Reifen: Port B
 *
 *  Sensor 1: Berührungssensor
 *  Sensor 2: Geräuschsensor
 *  Sensor 3: Licht
 *  Sensor 4: Ultraschall
 *
 *  Reifendurchmesser: 56mm
 *  Abstand der Reifen: 11,5 cm
 *
 *  Auf Cruiser.java zugeschnittene Wrapperklasse um den Sourcecode von Cruiser.java
 *  übersichtlicher zu halten. Außerdem kann mit dieser Klasse über das Feld
 *  wait_time in Millisekunden bestimmt werden,  in welchen Zeitabständen die Sensoren abgefragt werden sollen.
 *  (Standard: 0)
 */

public class Tribot {

	// Sensoren s_*
	private Light s_l;
	private Ultrasonic s_us;
	private Sound s_s;
	private Touch s_t;

	// Motoren m_*
	private SyncMotors m_sm;
	private ServoNavigator m_sn;

	// Hilfsvariablen für die get(Sensor) Methoden
	private long lc_light_time;
	private int lc_light_value;
	private long lc_ultrasonic_time;
	private int lc_ultrasonic_value;
	private long lc_sound_time;
	private int lc_sound_value;
	private long lc_touch_time;
	private boolean lc_touch_value;

	// Klaue
	private boolean clawOpen;
	private int openCount = 40;
	private int closeCount = 50;

    private int wait_time = 0;

	public Tribot() {
		// Sensoren initialisieren
		s_l = new Light(Sensor.S3);
		s_us = new Ultrasonic(Sensor.S4);
		s_s = new Sound(Sensor.S2);
		s_t = new Touch(Sensor.S1);

		// Motoren initialisieren
		m_sm = new SyncMotors(Motor.C, Motor.B);
		m_sm.setSpeed(36);
        Motor.A.setSpeed(24);
		m_sn = new ServoNavigator(56.0, 11.5, 360.0, m_sm);
		this.clawOpen = false;

		// getter Initialisieren
        lc_light_time = 0;
        lc_light_value = 0;
       	lc_ultrasonic_time = 0;
        lc_ultrasonic_value = 0;
       	lc_sound_time = 0;
        lc_sound_value = 0;
       	lc_touch_time = 0;
        lc_touch_value = false;
	}

	public void closeClaw() {
		if(clawOpen)
			Motor.A.backward(closeCount);
		clawOpen = false;
	}

	public void openClaw() {
		if(!clawOpen)
			Motor.A.forward(openCount);
		clawOpen = true;
	}

	public void forward() {
		m_sn.forward();
	}

	public void backward() {
		m_sn.backward();
	}

	public void stop() {
		m_sn.stop();
	}

	public void rotate(double degrees) {
		m_sn.rotate(degrees);
	}

	public double getAngle() {
		return m_sn.getAngle();
	}

	public void snapBall() {
		m_sm.backward(40);
		closeClaw();
	}

	public int getLight() {
		if(System.currentTimeMillis() - lc_light_time > wait_time)
			lc_light_value = s_l.getLightPercent();
		return lc_light_value;
	}

	public boolean getTouch() {
		if(System.currentTimeMillis() - lc_touch_time > wait_time)
			lc_touch_value = s_t.isPressed();
		return lc_touch_value;
	}

	public int getSound() {
		if(System.currentTimeMillis() - lc_sound_time > wait_time)
			lc_sound_value = s_s.getdB();
		return lc_sound_value;
	}

	public int getDistance() {
		if(System.currentTimeMillis() - lc_ultrasonic_time > wait_time)
			lc_ultrasonic_value = s_us.getDistance();
		return lc_ultrasonic_value;
	}

}
