/*
 * Decompiled with CFR 0.152.
 */
package icommand.vision;

import icommand.vision.Vision;
import java.io.IOException;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Processor;
import javax.media.ProcessorModel;
import javax.media.ResourceUnavailableEvent;
import javax.media.StopByRequestEvent;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.FileTypeDescriptor;
import javax.media.protocol.SourceCloneable;

public class Recorder
extends Thread
implements ControllerListener {
    private static Processor p;
    private Object waitSync = new Object();
    private boolean stateTransitionOK = true;
    private boolean eom = false;
    private boolean failed = false;
    private String filename;
    private int millis;

    public Recorder(String string, int n) {
        this.filename = string;
        this.millis = n;
    }

    public static void stopRecording() {
        p.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Vision.isRecording = true;
        DataSource dataSource = ((SourceCloneable)Vision.cds).createClone();
        Format[] formatArray = new Format[]{new AudioFormat("LINEAR"), new VideoFormat("cvid")};
        FileTypeDescriptor fileTypeDescriptor = new FileTypeDescriptor("video.quicktime");
        CaptureDeviceInfo captureDeviceInfo = CaptureDeviceManager.getDevice((String)Vision.soundDevice);
        DataSource[] dataSourceArray = new DataSource[2];
        dataSourceArray[0] = dataSource;
        System.out.println("Creating Audio data source");
        try {
            dataSourceArray[1] = Manager.createDataSource((MediaLocator)captureDeviceInfo.getLocator());
        }
        catch (Exception exception) {
            System.out.println("Failed to create Audio data source " + exception.getMessage());
            System.exit(1);
        }
        System.out.println("Creating Merging data source");
        DataSource dataSource2 = null;
        try {
            dataSource2 = Manager.createMergingDataSource((DataSource[])dataSourceArray);
        }
        catch (Exception exception) {
            System.out.println("Failed to merge data sources " + exception.getMessage());
            System.exit(-1);
        }
        try {
            p = Manager.createRealizedProcessor((ProcessorModel)new ProcessorModel(dataSource2, formatArray, (ContentDescriptor)fileTypeDescriptor));
        }
        catch (Exception exception) {
            System.err.println("Failed to create a processor from the given datasource: " + exception);
            System.exit(-1);
        }
        p.addControllerListener((ControllerListener)this);
        DataSource dataSource3 = p.getDataOutput();
        MediaLocator mediaLocator = new MediaLocator("file://" + this.filename + ".mov");
        DataSink dataSink = null;
        try {
            dataSink = Manager.createDataSink((DataSource)dataSource3, (MediaLocator)mediaLocator);
            dataSink.open();
        }
        catch (Exception exception) {
            System.out.println("Failed to create file writer");
            System.exit(-1);
        }
        try {
            dataSink.start();
        }
        catch (IOException iOException) {
            System.exit(-1);
        }
        p.start();
        this.waitForState(600);
        System.out.println("Recording...");
        if (this.millis > 0) {
            this.playToEndOfMedia(this.millis);
        } else {
            try {
                Object object = this.waitSync;
                synchronized (object) {
                    this.waitSync.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        p.close();
        Vision.isRecording = false;
        System.out.println("Finished");
        dataSink.close();
        Vision.p.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent controllerEvent) {
        System.out.println(this.getClass().getName() + controllerEvent);
        if (controllerEvent instanceof StopByRequestEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = true;
                this.waitSync.notifyAll();
            }
        } else if (controllerEvent instanceof ResourceUnavailableEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = false;
                this.failed = true;
                this.waitSync.notifyAll();
            }
        } else if (controllerEvent instanceof EndOfMediaEvent) {
            this.eom = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForState(int n) {
        Object object = this.waitSync;
        synchronized (object) {
            try {
                while (p.getState() != n && this.stateTransitionOK) {
                    this.waitSync.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.stateTransitionOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean playToEndOfMedia(int n) {
        long l = System.currentTimeMillis();
        this.eom = false;
        this.failed = false;
        Recorder recorder = this;
        synchronized (recorder) {
            while (!this.eom && !this.failed) {
                try {
                    this.wait(n);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - l <= (long)n) continue;
            }
        }
        return this.eom && !this.failed;
    }
}

