/*
 * Decompiled with CFR 0.152.
 */
package icommand.vision;

import icommand.vision.ColorListener;
import icommand.vision.LightListener;
import icommand.vision.MotionListener;

public class Region {
    public static int MAX_REGIONS = 32;
    private int x;
    private int y;
    private int w;
    private int h;
    private static final int MAX_MOTION_LISTENERS = 32;
    private static final int MAX_COLOR_LISTENERS = 32;
    private static final int MAX_LIGHT_LISTENERS = 32;
    private MotionListener[] motionListeners = new MotionListener[32];
    private int numMotionListeners = 0;
    private ColorListener[] colorListeners = new ColorListener[32];
    private int numColorListeners = 0;
    private int[] colors = new int[32];
    private LightListener[] lightListeners = new LightListener[32];
    private int numLightListeners = 0;

    public Region(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.w = n3;
        this.h = n4;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public boolean inRegion(int n, int n2) {
        return n >= this.x && n2 >= this.y && n <= this.x + this.w && n2 <= this.y + this.h;
    }

    public void addMotionListener(MotionListener motionListener) {
        this.motionListeners[this.numMotionListeners++] = motionListener;
    }

    public void addColorListener(ColorListener colorListener, int n) {
        this.colors[this.numColorListeners] = n;
        this.colorListeners[this.numColorListeners++] = colorListener;
    }

    public void addLightListener(LightListener lightListener) {
        this.lightListeners[this.numLightListeners++] = lightListener;
    }

    public MotionListener[] getMotionListeners() {
        MotionListener[] motionListenerArray = new MotionListener[this.numMotionListeners];
        for (int i = 0; i < this.numMotionListeners; ++i) {
            motionListenerArray[i] = this.motionListeners[i];
        }
        return motionListenerArray;
    }

    public ColorListener[] getColorListeners() {
        ColorListener[] colorListenerArray = new ColorListener[this.numColorListeners];
        for (int i = 0; i < this.numColorListeners; ++i) {
            colorListenerArray[i] = this.colorListeners[i];
        }
        return colorListenerArray;
    }

    public int[] getColors() {
        return this.colors;
    }

    public LightListener[] getLightListeners() {
        LightListener[] lightListenerArray = new LightListener[this.numLightListeners];
        for (int i = 0; i < this.numLightListeners; ++i) {
            lightListenerArray[i] = this.lightListeners[i];
        }
        return lightListenerArray;
    }
}

