import icommand.platform.nxt.*;
import icommand.nxtcomm.*;
import icommand.robotics.*;
import java.util.*;


/*
 *  Cruiser - Den Roboter zufällig über eine weiße Fläche fahren lassen,
 *  bis der Berührungssensor aktiviert wird. Dann klappt die Schere zu
 *  und das Programm beendet.
 *
 *  Sollte mit einem Tribot betrieben werden.
 *
 *  Motor für die Klaue: Port A
 *  Motor linker Reifen: Port C
 *  Motor rechter Reifen: Port B
 *
 *  Sensor 1: Berührungssensor
 *  Sensor 2: Geräuschsensor
 *  Sensor 3: Licht
 *  Sensor 4: Ultraschall
 *
 */


public class Cruiser implements Runnable {

	private Tribot bot;
	private int l_max;
	private int l_min;

	public void debug(String s) {
		System.out.println(s);
	}

	public static void main(String[] args) {
		Cruiser app = new Cruiser();
		app.run();
	}

	public Cruiser() {
		bot = new Tribot();
		l_min = 60;
		l_max = 100;
	}

	private boolean isBetween(int value, int min, int max) {
		if((value <= max) && (value >= min))
			return true;
		else
			return false;
	}

	public boolean findPath() {
        int color = bot.getLight();
		double current_angle = bot.getAngle();

		while(!isBetween(bot.getLight(), l_min, l_max) && ( bot.getAngle()-current_angle <= 15.0  )) {
			bot.rotate(5.0);
		}

		if(!isBetween(bot.getLight(), l_min, l_max))
			bot.rotate(-15.0);

		while(!isBetween(bot.getLight(), l_min, l_max) && ( bot.getAngle()-current_angle >= -15.0)) {
			bot.rotate(-5.0);
        }

		return isBetween(bot.getLight(), l_min, l_max);
	}

	public void newDirection() {
		Random r = new Random();
        if(r.nextInt(2)==0)
    		bot.rotate(r.nextInt(90) + 90);
        else
            bot.rotate((-1)*r.nextInt(90)+90);
	}

    public void goBackToLastWhite() {
        bot.backward();
		while(isBetween(bot.getLight(), l_min, l_max)) {
			System.out.println("Lichtsensor: " + bot.getLight());
		}
        bot.stop();
    }
    
	public void run() {
		boolean go = true;

		bot.openClaw();
		bot.forward();
		while(go) {
			if(!isBetween(bot.getLight(), l_min, l_max)) {
				System.out.println("Lichtsensor: " + bot.getLight());
				bot.stop();
                goBackToLastWhite();
//				if(!findPath())
				newDirection();
				bot.forward();
			}

			if(bot.getSound() > 40) {
				System.out.println("Soundsensor: " + bot.getSound());
				bot.stop();
				newDirection();
				bot.forward();
			}

/*
			if(bot.getDistance() < 20) {
				System.out.println("Zu kleiner Abstand: " + bot.getDistance());
				bot.stop();
				newDirection();
				bot.forward();
			}
*/

			if(bot.getTouch()) {
				System.out.println("Berührungssensor!");
				bot.stop();
				bot.snapBall();
				go = false;
			}
		}
		bot.stop();

        NXTCommand.close();
	}
}
