; ------------------------------------------------------------------------------------ ;
; nucleOS Standard Routines File (stdrtns.asm)                                         ;
;                                                                                      ;
; This file contains some useful functions and macros. You can use them after you have ;
; included this file with %include "path/stdrtns.asm" into your source code.           ;
;                                                                                      ;
; version 0.0.0.1                                                                      ;
;                                                                                      ;
; written by rochus                                                                    ;
;                                                                                      ;
; Copyright (c) 2004 nucle-os group [rochus [rochus@rochus.net]]                       ;
;                                                                                      ;
; This program is free software; you can redistribute it and/or modify it under the    ;
; terms of the GNU General Public License as published by the Free Software Foundation ;
; (version 2, June 1991)                                                               ;
;                                                                                      ;
; This program is distributed in the hope that it will be useful, but WITHOUT ANY      ;
; WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A      ;
; PARTICULAR PURPOSE. See the GNU General Public License for more details.             ;
;                                                                                      ;
; You should have received a copy of the GNU General Public License along with this    ;
; program; if not, write to:                                                           ;
; Free Software Foundation, Inc.                                                       ;
; 59 Temple Place, Suite 330                                                           ;
; Boston, MA 02111-1307 USA                                                            ;
;                                                                                      ;
; ------------------------------------------------------------------------------------ ;



; ------------------------------------------------------------------------------------ ;
; Macro mpush <n parameter>                                                            ;
; ------------------------------------------------------------------------------------ ;
; mpush helps to put more than one register on the stack and avoiding redundant lines  ;
; of hand typed code                                                                   ;
; ------------------------------------------------------------------------------------ ;
%macro mpush 1-*        ; either 1 or n registers to push
	%rep %0              ; %0 gets the number of parameters given to the macro
		push %1           ; push this one
		%rotate 1         ; make the second parameter the first, and so on.. (rotation)
	%endrep              ; end of repetition
%endmacro               ; end of macro
; ------------------------------------------------------------------------------------ ;
;                                                                                      ;
; example:                                                                             ;
;   mpush ax,bx                                                                        ;
;                                                                                      ;
; ------------------------------------------------------------------------------------ ;



; ------------------------------------------------------------------------------------ ;
; Macro mpop <n parameter>                                                             ;
; ------------------------------------------------------------------------------------ ;
; mppo helps to pop more than one register from the stack and avoiding redundant lines ;
; of hand typed code                                                                   ;
; ------------------------------------------------------------------------------------ ;
%macro mpop 1-*         ; either one or n registers to pop
	%rep %0              ; like above (mpush)
		%rotate -1        ; rotate it, but this time make the last the first, the first 
                        ; the second..
		pop %1            ; pop it!
	%endrep              ; end of repetition
%endmacro               ; end of macro
; ------------------------------------------------------------------------------------ ;
;                                                                                      ;
; example:                                                                             ;
;   mpop ax,bx                                                                         ;
;                                                                                      ;
;                                                                                      ;
; note: if you use mpush, take the sime order of arguments with mpop.                  ;
; example:                                                                             ;
;                                                                                      ;
;   mpush ax,bx                                                                        ;
;                ; a lot of code                                                       ;
;   mpop ax,bx                                                                         ;
;                                                                                      ;
; the macro is defined that way that it will first pop the last argument (n. argument) ;
; , then the (n-1). argument and so on                                                 ;
;                                                                                      ;
; ------------------------------------------------------------------------------------ ;





; ------------------------------------------------------------------------------------ ;
; The next two functions only work in REAL MODE! That's why there is a _Real at the    ;
; end of the function name                                                             ;
; ------------------------------------------------------------------------------------ ;

; ------------------------------------------------------------------------------------ ;
; Function PutPascalStr_Real                                                           ;
; ------------------------------------------------------------------------------------ ;
; PutPascalStr puts a string to screen whose first character is the length of the      ;
; string. usually, pascal strings are made up like that: [cnt][first char][second char];
; and so on..                                                                          ;
;                                                                                      ;
; so you have to define your strings like that:                                        ;
; MyString db 18,"This is my String!"                                                  ;
; note: strings can't be longer than 256 characters at that moment                     ;
;       will be changed soon, so that the extended registers are taken for saving the  ;
;       string length..                                                                ;
;                                                                                      ;
; to write a string, you have to load it to SI and then call PutPascalStr              ;
; example:                                                                             ;
;            mov  si,MyPascalString                                                    ;
;            call PutPascalStr                                                         ;
;                                                                                      ;
;            MyPascalString db 18,"This is my String!"                                 ;
; ------------------------------------------------------------------------------------ ;
PutPascalStr_Real:
   .start
      ; optional here: mpush ax,bx,cx
      push  ax          ;
      push  bx          ; save those registers
      push  cx          ;
   
      xor   ax,ax       ; set ax to zero
      xor   bx,bx       ; set bx to zero
      xor   cx,cx       ; set cx to zero
   
      lodsb             ; load single byte to al
      mov   cx,ax       ; first char is the count variable, so put it to cx
      
   .loop
      lodsb             ; now get the first real character of our string!
      mov   ah,0Eh      ; function, to put a character on screen (0Eh on int 10)
      mov   bl,0x0005   ; you could use bl to change the foreground color!
      int   0x10        ; interrupt to write character
      loop  .loop       ; loop until the string's out

   .end
      ; optional here: mpop ax,bx,cx
      pop   cx          ;
      pop   bx          ; get our registers back
      pop   ax          ;
      ret               ; return
   

; ------------------------------------------------------------------------------------ ;
; Function PutStr_Real                                                                 ;
; ------------------------------------------------------------------------------------ ;
; PutString puts a string to screen whose last character is a zero (zero-terminated    ;
; string that is well known under windows and that is very easy to handle with. take   ;
; care that you define your strings like                                               ;
; MyString db "This is my String!",0                                                   ;
;                                                                                      ;
; As in PutPascalStr you have to first load your string to SI:                         ;
; example:                                                                             ;
;           mov  si, MyZeroString                                                      ;
;           call PutStr                                                                ;
;                                                                                      ;
;           MyZeroString db "This is my Zero String!",0                                ;
; ------------------------------------------------------------------------------------ ;
PutStr_Real:
   .start
      ; optional: mpush ax,bx,cx
      push  ax          ;
      push  bx          ; save our registers that we want to use
      push  cx          ; 

      xor   ax,ax       ;
      xor   bx,bx       ; set our registers to zero, so that no errors occure
      xor   cx,cx       ;    
      
   .loop
      lodsb             ; load first character to al
      or    al,al        ; is al zero
      jz    .end        ; al is zero -> jump to end
      mov   ah,0Eh      ; character isn't zero -> write it!
      mov   bl,0x0005   ; use bl to define your foreground color
      int   0x10        ; interrupt to write character to standard output
      jmp   .loop       ; jump back for next character

   .end
      ; optional: mpop ax,bx,cx
      pop   cx          ; 
      pop   bx          ; get our registers back
      pop   ax          ; 
      ret               ; return