;****************************************************************************************
;* load_idt.s - sets up and loads our IDT
;*
;* written by Bastian Gloeckle (MrSaint), programmer of nucleOS
;*
;*
;* EXPORTS: procedure setup_idt (used by idt.pp): sets up and loads the IDT
;*
;*
;* Copyright (C) 2004 by nucleOS group
;*
;* This program is free software; you can redistribute it and/or modify it under the
;* terms of the GNU General Public License as published by the Free Software Foundation
;* (version 2, June 1991)
;*
;* This program is distributed in the hope that it will be useful, but WITHOUT ANY
;* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
;* PARTICULAR PURPOSE. See the GNU General Public License for more details.
;*
;* You should have received a copy of the GNU General Public License along with this
;* program; if not, write to:
;* Free Software Foundation, Inc.
;* 59 Temple Place, Suite 330
;* Boston, MA 02111-1307 USA
;*
;*
;* You can contact me by electronic mail: admin@saint-soft.de
;****************************************************************************************

BITS 32

IDT_LOCATION	equ	0FFF00500h
IDT_LENGTH	equ	256*8-1
OUR_INTERRUPT	equ	21h

DEST_SEG	equ	08h

LINEAR_SEL	equ	08h


SECTION .text

; ........................................................
; This is the main procedure. It sets up the IDT and
; loads it
;
; INPUT:
;	stack:
;       +---------------------------------------+ < [ebp]
;		|               old EBP                 |
;		+---------------------------------------+ < [ebp+4]
;       |                 ???                   |
;       +---------------------------------------+ < [ebp+8]
;		|      adress of unhandled-handler      |
;		+---------------------------------------+ < [ebp+12]
;		|    adress for our interrupt handler   |
;		+---------------------------------------+
;       |                 ...                   |
;
; ........................................................
;EXTERN PF_ISR

	GLOBAL SETUP_IDT
	SETUP_IDT:
        push ebp
        mov ebp, esp

		push eax
		push ecx
		push edi
		push fs

        mov eax, [ebp+8]
        mov dword [unhandled_addr], eax
        mov eax, [ebp+12]
        mov dword [our_int_addr], eax

		; code converted from linux!
		mov edx, [unhandled_addr]		; get adress of unhandled-handler
		mov ax, LINEAR_SEL
		mov fs, ax
		xor eax, eax
		mov ax, DEST_SEG			; destination segment
		shl eax, 16
		mov ax, dx
;		mov dx, 08E00h				; = interrupt gate
        mov dx, 0EE00h
		mov ecx, 256
		mov edi, IDT_LOCATION
		idt_loop:
			mov [fs:edi], eax
			mov [fs:edi+4], edx
			add edi, 8
			dec ecx
			jnz idt_loop

		; end of code coverted from linux
		; Set the adress of our interrupt

		mov edx, [our_int_addr]			; get adress of our interrupt handler
		xor eax, eax
		mov ax, DEST_SEG			; dest segment
		shl eax, 16
		mov ax, dx
;		mov dx, 08E00h				; = interrupt gate
        mov dx, 0EE00h
		mov edi, IDT_LOCATION
		add edi, OUR_INTERRUPT*8		; go to the adress of our interrupt
		mov [fs:edi], eax
		mov [fs:edi+4], edx

		cli

		lidt [idt_reg]				; LOAD IDT

		sti

		pop fs					; restore registers
		pop edi
		pop ecx
		pop eax
		pop edx

        leave
		retn


SECTION .data

    GLOBAL _IDTBASE
    _IDTBASE: dd IDT_LOCATION

	idt_reg:
		dw IDT_LENGTH
		dd IDT_LOCATION

	unhandled_addr:
		dd 0

	our_int_addr:
		dd 0

SECTION .bss
