/***************************************************************************
 *   Copyright (C) 2008 by Michael Gerhäuser   *
 *   michael.gerhaeuser@gmx.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#pragma once

#include <ctime>
#include <cstdlib>
#include <fstream>
#include "bitops.h"

#define SCALE 10000.

typedef int MY_DATA;
typedef double REAL_DATA;

void init_operators();
void rekombination(MY_DATA * vater, MY_DATA * mutter, MY_DATA * kind);
void mutation(int * individuum);
void selektion(MY_DATA ** population, int groesse, MY_DATA ** kinder, int anzahl_kinder, MY_DATA * target, int * indizes);
void erzeuge_individuum(MY_DATA * individuum);
void erzeuge_adam_und_eva(MY_DATA ** population, int groesse);
void erzeuge_naechste_generation(MY_DATA ** population, int groesse, MY_DATA ** kinder_generation, int anzahl_kinder);
void population_speichern(MY_DATA ** population, int groesse, string filename);

template <typename T>
void vektor_speichern(T * data, int groesse, string filename) {
    ofstream datei;
    datei.open(filename.c_str());

    for(int i=0; i<groesse; i++) {
        datei << data[i] << endl;
    }

    datei.close();
}

