/***************************************************************************
 *   Copyright (C) 2008 by Michael Gerhäuser   *
 *   michael.gerhaeuser@gmx.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "bitops.h"

int setBit(int * op, int pos, bool bit) {
    if(bit)
	    *op = ( *op | ( 1 << pos ) );
    else
        *op = ( *op & ( ~( 1 << pos ) ) );

	return *op;
}

bool isBitSet(int op, int pos) {
    int copy = op;
    if(pos>RELEVANT_BITS)
        return false;

    return ( ( ( copy >> pos ) & 1 ) == 1);
}

int invertBits(int * op) {
    for(int i=0; i<32; i++) {
        setBit(op, i, !isBitSet(*op, i));
    }
    return *op;
}

void printBits(int op) {
    cout << setw(12) << op << ": ";
    for(int i=RELEVANT_BITS-1; i>-1; i--) {
        if(isBitSet(op, i))
            cout << "1";
        else
            cout << "0";
    }
    cout << endl;
}

int encodeGray(int op) {
    return (op ^ (op >> 1));
}

int decodeGray(int op) {
    int sb = 0;
    int bi, gi;
    bool setit;

    setBit(&sb, RELEVANT_BITS, isBitSet(sb, RELEVANT_BITS));
    for(int i=RELEVANT_BITS-1; i>-1; i--) {
        bi = (isBitSet(sb, i+1) ? 1 : 0);
        gi = (isBitSet(op, i) ? 1 : 0);
        setit = false;
        if( (bi ^ gi) == 1 )
            setit = true;

        setBit(&sb, i, setit);
    }

    return sb;
}
