/*
 * Decompiled with CFR 0.152.
 */
package icommand.vision;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import icommand.vision.ColorEffect;
import icommand.vision.ColorListener;
import icommand.vision.FlipEffect;
import icommand.vision.LightListener;
import icommand.vision.MotionDetectionEffect;
import icommand.vision.MotionListener;
import icommand.vision.Recorder;
import icommand.vision.Region;
import icommand.vision.RegionEffect;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.media.CaptureDeviceManager;
import javax.media.Codec;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.PrefetchCompleteEvent;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.UnsupportedPlugInException;
import javax.media.control.FormatControl;
import javax.media.control.TrackControl;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Vision
extends Frame
implements ControllerListener {
    static int imageWidth = -1;
    static int imageHeight = -1;
    static float frameRate = 15.0f;
    static String snapshotFilename;
    static Processor p;
    static DataSource cds;
    static String cameraDevice;
    static String soundDevice;
    static boolean isRecording;
    static Recorder recorder;
    static boolean captureColor;
    static Vision visionFrame;
    static ColorEffect colorEffect;
    static FlipEffect flipEffect;
    static RegionEffect regionEffect;
    static MotionDetectionEffect motionDetectionEffect;
    private Object waitSync = new Object();
    private boolean stateTransitionOK = true;
    private static Properties videoProperties;
    private static final String DEFAULT_VIDEO_DEV_NAME = "vfw:Logitech USB Video Camera:0";
    private static final String DEFAULT_SOUND_DEV_NAME = "DirectSoundCapture";
    private static Region[] regions;
    private static boolean takeSnapshot;
    private static final long serialVersionUID = 3257286945972432951L;

    public Vision(String string) {
        super(string);
    }

    public static Frame getFrame() {
        return visionFrame;
    }

    public boolean open(DataSource dataSource) {
        Object object;
        cds = Manager.createCloneableDataSource((DataSource)dataSource);
        try {
            p = Manager.createProcessor((DataSource)cds);
        }
        catch (Exception exception) {
            System.err.println("Failed to create a processor from the given datasource: " + exception);
            return false;
        }
        p.addControllerListener((ControllerListener)this);
        p.configure();
        if (!this.waitForState(180)) {
            System.err.println("Failed to configure the processor.");
            return false;
        }
        p.setContentDescriptor(null);
        TrackControl[] trackControlArray = p.getTrackControls();
        if (trackControlArray == null) {
            System.err.println("Failed to obtain track controls from the processor.");
            return false;
        }
        TrackControl trackControl = null;
        for (int i = 0; i < trackControlArray.length; ++i) {
            if (!(trackControlArray[i].getFormat() instanceof VideoFormat)) continue;
            trackControl = trackControlArray[i];
            break;
        }
        if (trackControl == null) {
            System.err.println("The input media does not contain a video track.");
            return false;
        }
        try {
            object = new Codec[]{flipEffect, motionDetectionEffect, regionEffect, colorEffect};
            trackControl.setCodecChain(object);
        }
        catch (UnsupportedPlugInException unsupportedPlugInException) {
            System.err.println("The processor does not support effects.");
            return false;
        }
        p.prefetch();
        if (!this.waitForState(500)) {
            System.err.println("Failed to realize the processor.");
            return false;
        }
        this.setLayout(new BorderLayout());
        Component component = p.getVisualComponent();
        if (component != null) {
            this.add("Center", component);
        }
        if ((object = p.getControlPanelComponent()) != null) {
            this.add("South", (Component)object);
        }
        p.start();
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                p.close();
                System.exit(0);
            }
        });
        return true;
    }

    public static void stopViewer() {
        visionFrame.setVisible(false);
        p.close();
    }

    public void addNotify() {
        super.addNotify();
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForState(int n) {
        Object object = this.waitSync;
        synchronized (object) {
            try {
                while (p.getState() != n && this.stateTransitionOK) {
                    this.waitSync.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.stateTransitionOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof ConfigureCompleteEvent || controllerEvent instanceof RealizeCompleteEvent || controllerEvent instanceof PrefetchCompleteEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = true;
                this.waitSync.notifyAll();
            }
        } else if (controllerEvent instanceof ResourceUnavailableEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = false;
                this.waitSync.notifyAll();
            }
        } else if (controllerEvent instanceof EndOfMediaEvent) {
            p.close();
            System.out.println("End of Media");
            System.exit(0);
        }
    }

    public static void startViewer(String string) {
        FileInputStream fileInputStream;
        String string2 = System.getProperty("video.properties", "video.properties");
        try {
            fileInputStream = new FileInputStream(new File(string2));
            videoProperties = new Properties();
            videoProperties.load(fileInputStream);
        }
        catch (IOException iOException) {
            System.err.println("Failed to read property file");
            System.exit(1);
        }
        cameraDevice = videoProperties.getProperty("video-device-name", DEFAULT_VIDEO_DEV_NAME);
        soundDevice = videoProperties.getProperty("sound-device-name", DEFAULT_SOUND_DEV_NAME);
        if (imageWidth < 0) {
            imageWidth = Integer.parseInt(videoProperties.getProperty("resolution-x", "320"));
        }
        if (imageHeight < 0) {
            imageHeight = Integer.parseInt(videoProperties.getProperty("resolution-y", "320"));
        }
        if ((fileInputStream = CaptureDeviceManager.getDevice((String)cameraDevice)) == null) {
            System.out.println("No device found [ " + cameraDevice + "]");
            System.exit(1);
        }
        MediaLocator mediaLocator = fileInputStream.getLocator();
        DataSource dataSource = null;
        try {
            dataSource = Manager.createDataSource((MediaLocator)mediaLocator);
        }
        catch (Exception exception) {
            System.err.println("Failed to create a datasource");
            System.exit(1);
        }
        FormatControl[] formatControlArray = ((CaptureDevice)dataSource).getFormatControls();
        RGBFormat rGBFormat = new RGBFormat(new Dimension(imageWidth, imageHeight), imageWidth * imageHeight * 3 + 4, Format.byteArray, frameRate, 24, 3, 2, 1, 3, -1, 1, -1);
        if (formatControlArray == null || formatControlArray.length == 0) {
            System.out.println("No format controls");
            System.exit(1);
        }
        for (int i = 0; i < formatControlArray.length; ++i) {
            if (formatControlArray[i] == null) continue;
            formatControlArray[i].setFormat((Format)rGBFormat);
        }
        visionFrame = new Vision(string);
        if (!visionFrame.open(dataSource)) {
            System.exit(1);
        }
    }

    public static void playSound(String string) {
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(new File(string));
            AudioFormat audioFormat = audioInputStream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, audioInputStream.getFormat(), (int)audioInputStream.getFrameLength() * audioFormat.getFrameSize());
            Clip clip = (Clip)AudioSystem.getLine(info);
            clip.open(audioInputStream);
            clip.start();
        }
        catch (IOException iOException) {
            System.err.println("Audio file not found");
        }
        catch (LineUnavailableException lineUnavailableException) {
            System.err.println("Could not play the audio file");
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            System.err.println("Unsupported Audio File Format");
        }
    }

    public static void addRectRegion(int n, int n2, int n3, int n4, int n5) {
        Vision.regions[n - 1] = new Region(n2, n3, n4, n5);
    }

    public static Region[] getRegions() {
        return regions;
    }

    public static void setFrameRate(float f) {
        frameRate = f;
    }

    public static void setImageSize(int n, int n2) {
        imageWidth = n;
        imageHeight = n2;
    }

    public static void addMotionListener(int n, MotionListener motionListener) {
        regions[n - 1].addMotionListener(motionListener);
    }

    public static void addColorListener(int n, ColorListener colorListener, int n2) {
        regions[n - 1].addColorListener(colorListener, n2);
    }

    public static void addLightListener(int n, LightListener lightListener) {
        regions[n - 1].addLightListener(lightListener);
    }

    static boolean takeSnapshot() {
        return takeSnapshot;
    }

    public static void snapshot(String string) {
        snapshotFilename = string;
        takeSnapshot = true;
    }

    static void setSnapshot(boolean bl) {
        takeSnapshot = bl;
    }

    public static void writeImage(String string, byte[] byArray, int n, int n2) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
        int[] nArray = new int[byArray.length / 3];
        int n3 = 0;
        for (int i = n2 - 1; i > 0; --i) {
            for (int j = 0; j < n; ++j) {
                nArray[n3++] = 0xFF000000 | (byArray[i * n * 3 + j * 3 + 2] & 0xFF) << 16 | (byArray[i * n * 3 + j * 3 + 1] & 0xFF) << 8 | byArray[i * n * 3 + j * 3] & 0xFF;
            }
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        bufferedImage.setRGB(0, 0, n, n2, nArray, 0, n);
        jPEGImageEncoder.encode(bufferedImage);
        fileOutputStream.close();
    }

    public static void startRecorder(String string, int n) {
        recorder = new Recorder(string, n);
        recorder.start();
    }

    public static boolean isRecording() {
        return isRecording;
    }

    public static void stopRecording() {
        Recorder.stopRecording();
    }

    public static int getAvgRed(int n) {
        return Vision.colorEffect.averageRed[n - 1];
    }

    public static int getAvgGreen(int n) {
        return Vision.colorEffect.averageGreen[n - 1];
    }

    public static int getAvgBlue(int n) {
        return Vision.colorEffect.averageBlue[n - 1];
    }

    public static int getAvgRGB(int n) {
        return new Color(Vision.getAvgRed(n), Vision.getAvgGreen(n), Vision.getAvgBlue(n)).getRGB() & 0xFFFFFF;
    }

    public static void flipHorizontal(boolean bl) {
        Vision.flipEffect.flip = bl;
    }

    static {
        isRecording = false;
        captureColor = false;
        colorEffect = new ColorEffect();
        flipEffect = new FlipEffect();
        regionEffect = new RegionEffect();
        motionDetectionEffect = new MotionDetectionEffect();
        regions = new Region[Region.MAX_REGIONS];
        takeSnapshot = false;
    }
}

