{******************************************************************************
 *  ports.pp - basic I/O ports access
 *
 *
 *  Copyright (c) 2004 nucleOS Group [http://nucle-os.sourceforge.net/]
 *                                   [http://www.sf.net/projects/nucle-os]
 *                                   [http://www.saint-soft.de/nucleos/board/]
 *
 *  version 0.1 - 14/02/2004 - first release
 *
 *  written by
 *    Michael Gerh"auser (saberrider) [saberrider@users.sourceforge.net]
 *
 *  This file does:
 *   - providing access to ports
 *
 * This program is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software Foundation
 * (version 2, June 1991)
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program; if not, write to:
 * Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330
 * Boston, MA 02111-1307 USA
 *
 ******************************************************************************}


unit ports;


interface

procedure  poutb( port: word; value: byte );
procedure  poutw( port: word; value: word );
procedure  poutd( port: word; value: dword );
function   pinb( port: word ): byte;
function   pinw( port: word ): word;
function   pind( port: word ): dword;


implementation

{******************************************************************************
 * poutb
 ******************************************************************************
 * port:  destination port
 * value: byte to write
 *
 * writes _value to _port
 ******************************************************************************}
procedure poutb( port: word; value: byte ); [public, alias : 'POUTB'];
var
    p: pointer;
begin
    p := @value;

    asm
      mov esi, p
      mov dx, port
      outsb
    end;
end;  { poutb }

{******************************************************************************
 * poutw
 ******************************************************************************
 * port:  destination port
 * value: word to write
 *
 * writes _value to _port
 ******************************************************************************}
procedure poutw( port: word; value: word ); [public, alias : 'POUTW'];
var
    p: pointer;
begin
    p := @value;

    asm
      mov esi, p
      mov dx, port
      outsw
    end;
end;  { poutw }

{******************************************************************************
 * poutd
 ******************************************************************************
 * port:  destination port
 * value: dword to write
 *
 * writes _value to _port
 ******************************************************************************}
procedure poutd( port: word; value: dword ); [public, alias : 'POUTD'];
var
    p: pointer;
begin
    p := @value;

    asm
      mov esi, p
      mov dx, port
      outsd
    end;
end;  { poutd }

{******************************************************************************
 * pinb
 ******************************************************************************
 * port:   source port
 * result: byte read from port
 *
 * read value from _port
 ******************************************************************************}
function pinb( port: word ): byte; [public, alias : 'PINB'];
var
    p: ^byte;
begin
    asm
      mov esi, p
      mov dx, port
      insb
    end;
    pinb := p^;
end;  { pinb }

{******************************************************************************
 * pinw
 ******************************************************************************
 * port:   source port
 * result: word read from port
 *
 * read value from _port
 ******************************************************************************}
function pinw( port: word ): word; [public, alias : 'PINW'];
var
    p: ^word;
begin
    asm
      mov esi, p
      mov dx, port
      insw
    end;
    pinw := p^;
end;  { pinw }

{******************************************************************************
 * pinb
 ******************************************************************************
 * port:   source port
 * result: byte read from port
 *
 * read value from _port
 ******************************************************************************}
function pind( port: word ): dword; [public, alias : 'PIND'];
var
    p: ^dword;
begin
    asm
      mov esi, p
      mov dx, port
      insd
    end;
    pind := p^;
end;  { pind }

begin
end.

