{
  This is just a simple hello-world kernel written by MrSaint, nucleOS Group
  kernel extended to test "library" by saberrider, nucleOS Group
}

{$define DEBUG}

program kernel;

uses convert, strings, init_mm, mm, idt, pic, ports, init_mt;

const newline: string = ' ';
      startup1: string = 'nucleOS v0.1';
      startup2: string = '(c) 2004 nucleOS Group - http://nucle-os.sf.net/';
      startup3: string = '  This program is free software; you can redistribute it and/or modify it';
      startup4: string = '  under the terms of the GNU General Public License as published by the';
      startup5: string = '  Free Software Foundation (version 2, June 1991)';

var tmp: String;
    i: integer;
    freelist: mem_header; cvar;
    alloclist: mem_header; cvar;

    brk: longint; cvar; external;
    bGFXDRVCurrentX: byte; cvar; external;		{ this are the coordinates of the current text-output }
    bGFXDRVCurrentY: byte; cvar; external;
    Compiler: String; cvar; external;



// Implemented this function to make debugging easier
// and source code smaller.

procedure print_string( value: pointer); assembler; [public, alias:'WRITELN'];
asm
    mov esi, value   // load string
    mov ah, 01h
    int 21h            // Our self-implemented output-text-to-screen-interrupt
end;

procedure std_irq_isr;interrupt; [public, alias:'STD_IRQ_ISR'];
var
	t : string;
begin
	asm
	   sti
	end;

	t := ':irq int occured:';
	print_string(@t);

   poutb($A0, $20);
   poutb($20, $20);
end;



begin

  asm
    mov esi, $500		{ output_row is saved at 500h from SETUP }
    mov ax, 08h
    mov fs, ax
    mov al, byte fs:[esi]
    mov [bGFXDRVCurrentY], al
    inc esi
    mov eax, dword fs:[esi]
    mov [brk], eax
  end;
  
  brk := brk + $D2C00000;

  { initialise freelist & alloclist. not the best method either, but
    it should to work for now }
  freelist.next := @freelist;
  freelist.size := 0;
  alloclist.next := @alloclist;
  alloclist.size := 0;

  { reinitialize IDT & GDT, setup Physical Memory Manager }
  mm_init;

  { Print a little Copyright on startup }
  Print_String ( @startup1 );
  Print_String ( @startup2 );
  Print_String ( @newline );
  Print_String ( @startup3 );
  Print_String ( @startup4 );
  Print_String ( @startup5 );
  Print_String ( @newline );

  {$ifdef DEBUG}
  tmp := 'Compiled with ' + Compiler;
  Print_String ( @tmp );
  Print_String ( @newline );
  {$endif}


//  init_PIC;
  for i := 40 to 55 do
      set_interrupt( i, @std_irq_isr );
  program_PIC($28, $30);	{ IRQ 0 -> INT 28h ... IRQ 15 -> INT 37h }

  asm
//    cli
//    hlt
    @anhalten:
    jmp @anhalten
  end;
end.
