//--------------------------------------------------------------------------------------//
//                                                                                      //
// Startup code for nucleOS PE executables                                              //
// Written by saberrider, programmer of nucleOS                                         //
//                                                                                      //
// Copyright (C) 2004 by nucleOS group                                                  //
//                                                                                      //
// This file is part of the nucleOS FreePascal Compiler RTL                             //
// parts of this file are based upon the FreePascal Compiler RTL                        //
// written and copyrighted by members of the Free Pascal Development team               //
//                                                                                      //
//--------------------------------------------------------------------------------------//
//                                                                                      //
// This program is free software; you can redistribute it and/or modify it under the    //
// terms of the GNU Library General Public License as published by the                  //
// Free Software Foundation (version 2, June 1991)                                      //
//                                                                                      //
// This program is distributed in the hope that it will be useful, but WITHOUT ANY      //
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A      //
// PARTICULAR PURPOSE. See the GNU Library General Public License for more details.             //
//                                                                                      //
// You should have received a copy of the GNU Library General Public License along      //
// with this program; if not, write to:                                                 //
// Free Software Foundation, Inc.                                                       //
// 59 Temple Place, Suite 330                                                           //
// Boston, MA 02111-1307 USA                                                            //
//                                                                                      //
//                                                                                      //
// You can contact me by electronic mail: saberrider@users.sourceforge.net              //
//                                                                                      //
//--------------------------------------------------------------------------------------//

unit syswin32;

interface

{$Y-}

type
  ShortInt  = -128..127;
  SmallInt  = -32758..32767;
  LongInt   = $80000000..$7fffffff;
  Integer   = LongInt;
  Int       = SmallInt;
  Byte      = 0..255;
  Word      = 0..65535;
  DWord     = Cardinal;
  LongWord  = Cardinal;

  pChar     = ^Char;
  pPChar    = ^pChar;
  pShortString = ^ShortString;
  pString   = ^String;
  pSmallInt = ^SmallInt;
  pLongInt  = ^LongInt;
  pInteger  = ^Integer;
  pByte     = ^Byte;
  pWord     = ^Word;
  pDWord    = ^DWord;
  pSingle   = ^Single;
  pDouble   = ^Double;
  pExtended = ^Extended;
  pPointer  = ^Pointer;

{
  TODO:
   - implement int64 support
}

procedure PascalMain; external name 'PASCALMAIN';

implementation

procedure Exe_entry;[public, alias: '_FPC_EXE_Entry'];
begin
asm
	call PASCALMAIN
end;
end;



{$ASMMODE ATT}

{
  Following procedures are used ONLY by FPC and are written and copyrighted
  by members of the Free Pascal Development Team except comments in
  procedure int_strcopy: Copyright (c) 2004 saberrider, nucleOS Group

  These procedures are all taken from i386.inc in directory [fpc]/source/rtl/i386.

  The source code of the Free Pascal Runtime Library is distributed under
  a modified library GNU Library General Public License, which can be
  found in the file COPYING.

  If you didn't receive a copy of the file COPYING, contact:
      Free Software Foundation, Inc.,
      59 Temple Place - Suite 330
      Boston, MA 02111
      USA
}


procedure do_in_byte(p : pointer;b : byte);assembler;[public,alias:'FPC_SET_IN_BYTE'];
{
  tests if the element b is in the set p the carryflag is set if it present
}
asm
       pushl %eax
       movl p,%edi
       movb b,%al
       andl $0xf8,%eax
       shrl $3,%eax
       addl %eax,%edi
       movb b,%al
       andl $7,%eax
       btl %eax,(%edi)
       popl %eax
end;

procedure int_strcopy(len:longint;sstr,dstr:pointer);[public,alias:'FPC_SHORTSTR_COPY'];
begin
  asm
        pushl   %eax
        pushl   %ecx
        cld
        movl    dstr,%edi	// edi = dest string
        movl    sstr,%esi	// esi = src string
        xorl    %eax,%eax	// eax = 0
        movl    len,%ecx	// ecx = len
        lodsb			// al = first byte of src string
        cmpl    %ecx,%eax	// eax >= ecx ??
        jbe     .LStrCopy1
        movl    %ecx,%eax	// if eax <= ecx then eax := ecx
.LStrCopy1:
        stosb			// store new length
        cmpl    $7,%eax		// eax = 7 ?
        jl      .LStrCopy2	// if eax < 7 then jmp to LStrCopy2
        movl    %edi,%ecx       // |
        negl    %ecx		// | if length(srcstr) != 0 mod 4 then
        andl    $3,%ecx		// | we copy as many single bytes (max 3!)
        subl    %ecx,%eax	// | til we have to copy an amount of bytes
        rep			// | which is 0 mod 4. -> Align on 32 Bits
        movsb			// |
        movl    %eax,%ecx	// amount of bytes we still have to copy
        andl    $3,%eax		// eax = ecx mod 4
        shrl    $2,%ecx		// ecx = ecx div 4 (we copy 4 bytes at once)
        rep			// copy srcstr (esi) to
        movsl			// deststr (edi)
.LStrCopy2:
        movl    %eax,%ecx	// | if length(srcstr) >= 7 then
        rep			// | this code should not be executed,
        movsb			// | 'cause ecx should be zero
        popl    %ecx
        popl    %eax
  end ['ESI','EDI'];
end;

procedure int_strconcat(s1,s2:pointer); [public,alias:'FPC_SHORTSTR_CONCAT'];
begin
  asm
        movl    s2,%edi
        movl    s1,%esi
        movl    %edi,%ebx
        movzbl  (%edi),%ecx
        xor     %eax,%eax
        lea     1(%edi,%ecx),%edi
        negl    %ecx
        addl    $0x0ff,%ecx
        lodsb
        cmpl    %ecx,%eax
        jbe     .LStrConcat1
        movl    %ecx,%eax
.LStrConcat1:
        addb    %al,(%ebx)
        cmpl    $7,%eax
        jl      .LStrConcat2
        movl    %edi,%ecx
        negl    %ecx
        andl    $3,%ecx
        subl    %ecx,%eax
        rep
        movsb
        movl    %eax,%ecx
        andl    $3,%eax
        shrl    $2,%ecx
        rep
        movsl
.LStrConcat2:
        movl    %eax,%ecx
        rep
        movsb
  end ['EBX','ECX','EAX','ESI','EDI'];
end;


procedure int_strcmp(dstr,sstr:pointer);[public,alias:'FPC_SHORTSTR_COMPARE'];
begin
  asm
        cld
        xorl    %ebx,%ebx
        xorl    %eax,%eax
        movl    sstr,%esi
        movl    dstr,%edi
        movb    (%esi),%al
        movb    (%edi),%bl
        movl    %eax,%edx
        incl    %esi
        incl    %edi
        cmpl    %ebx,%eax
        jbe     .LStrCmp1
        movl    %ebx,%eax
.LStrCmp1:
        cmpl    $7,%eax
        jl      .LStrCmp2
        movl    %edi,%ecx
        negl    %ecx
        andl    $3,%ecx
        subl    %ecx,%eax
        orl     %ecx,%ecx
        rep
        cmpsb
        jne     .LStrCmp3
        movl    %eax,%ecx
        andl    $3,%eax
        shrl    $2,%ecx
        orl     %ecx,%ecx
        rep
        cmpsl
        je      .LStrCmp2
        movl    $4,%eax
        sub     %eax,%esi
        sub     %eax,%edi
.LStrCmp2:
        movl    %eax,%ecx
        orl     %eax,%eax
        rep
        cmpsb
        jne     .LStrCmp3
        cmp     %ebx,%edx
.LStrCmp3:
  end ['EDX','ECX','EBX','EAX','ESI','EDI'];
end;

{
  end of code copyrighted by Free Pascal Development Team
}

{$ASMMODE intel}


procedure InitializeUnits;[public,alias:'FPC_INITIALIZEUNITS'];
begin
end;

procedure do_exit;[public,alias:'FPC_DO_EXIT'];
begin
end;

begin
end.
