{
  This is just a simple hello-world kernel written by MrSaint, nucleOS Group
  kernel extended to test "library" by saberrider, nucleOS Group
}

{$define DEBUG}

program kernel;

uses convert, strings, init_mm, mm, idt, pic, ports, init_mt, gfxdrvunit;

const
//    startup1: string = 'nucleOS v0.1';
//    startup2: string = '(c) 2004 nucleOS Group - http://nucle-os.sf.net/';
    startup3: string = '  This program is free software; you can redistribute it and/or modify it';
    startup4: string = '  under the terms of the GNU General Public License as published by the';
    startup5: string = '  Free Software Foundation (version 2, June 1991)';

var
    tmp: String;
    ptr: PString;
    i: integer;
    freelist: mem_header; cvar;
    alloclist: mem_header; cvar;

    brk: longint; cvar; external;
    bGFXDRVCurrentX: byte; cvar; external;		{ this are the coordinates of the current text-output }
    bGFXDRVCurrentY: byte; cvar; external;
    bGFXDRVCurrentAttribute: byte; cvar; external;
    Compiler: String; cvar; external;



// Implemented this function to make debugging easier
// and source code smaller.

{procedure print_string( value: pointer); assembler; [public, alias:'WRITELN'];
asm
   mov esi, value   // load string
   mov ah, 01h
   int 21h            // Our self-implemented output-text-to-screen-interrupt
end;}

procedure std_irq_isr;interrupt; [public, alias:'STD_IRQ_ISR'];
begin
  asm
    sti
  end;

  writeln(':irq int occured:');

  poutb($A0, $20);
  poutb($20, $20);

  asm
//    add ebp, 4
  end;
end;

procedure timer_irq_isr;interrupt; [public, alias:'TIMER_IRQ_ISR'];
begin
  asm
    sti
  end;

  write(':timer:');

  poutb($A0, $20);
  poutb($20, $20);

  asm
//    add ebp, 4
  end;
end;


begin
  asm
    mov esi, $FFF00500		{ output_row is saved at 500h from SETUP }
    mov ax, 08h
    mov fs, ax
    mov al, byte [esi]
    mov [bGFXDRVCurrentY], al
    inc esi
    mov eax, dword [esi]
    mov [brk], eax
  end;

  bGFXDRVCurrentAttribute := $07;

  brk := brk + $E3800000;

  { initialise freelist & alloclist. not the best method either, but
    it should to work for now }
  freelist.next := @freelist;
  freelist.size := 0;
  alloclist.next := @alloclist;
  alloclist.size := 0;

  { reinitialize IDT & GDT, setup Physical Memory Manager }
  mm_init;

  { Print a little Copyright on startup }
  SetAttributes(12, 0);
  write('nucle');
  SetAttributes(15, 0);
  write('OS');
  SetAttributes(7, 0);
  writeln(' v0.1');

  write('(c) 2004 nucleOS Group - ');
  SetAttributes(9, 0);
  writeln('http://nucle-os.sf.net/');
  SetAttributes(7, 0);

  writeln('');
  writeln(startup3);
  writeln(startup4);
  writeln(startup5);
  writeln('');

  {$ifdef DEBUG}
  writeln( 'Compiled with ' + Compiler );
  {$endif}

  writeln('');

  enablePIT(5000);
//  disablePIT;
//  set_interrupt( 40, @timer_irq_isr );
  for i := 41 to 55 do
      set_interrupt( i, @std_irq_isr );
  program_PIC($28, $30);	{ IRQ 0 -> INT 28h ... IRQ 15 -> INT 37h }

  tmp := 'fulll';

  asm
  @output:
    mov eax, $FFFFFFFF
  @ende:
    dec eax
    jz @output
  jmp @ende
  end;
end.
