{******************************************************************************
 *  init_mt.pp - initialise multitasking
 *
 *
 *  Copyright (c) 2004 nucleOS Group [http://nucle-os.sourceforge.net/]
 *                                   [http://www.sf.net/projects/nucle-os]
 *                                   [http://www.saint-soft.de/nucleos/board/]
 *
 *  version 0.1 - 20/03/2004 - initial release
 *
 *  written by
 *    Bastian Gloeckle (MrSaint) [admin@saint-soft.de]
 *   Michael Gerh"auser (saberrider) [saberrider@users.sourceforge.net]
 *
 *  This file does
 *   - initialise multitasking
 *
 * This program is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software Foundation
 * (version 2, June 1991)
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program; if not, write to:
 * Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330
 * Boston, MA 02111-1307 USA
 *
 ******************************************************************************}


unit init_mt;

interface

uses bits, idt, ports, mm;

{* Types *}
type
    PTask = ^NTask;
    NTask = record
          eax, ebx, ecx, edx,
          eip, eflags, esp,
          esi, edi, cr3:      LongInt;
          priority:           Byte;
          next:               PTask;
    end;

    PTSS_Desc = ^NTSS_Desc;
    NTSS_Desc = record
          limit1    : word;
          base1     : word;
          base2     : byte;
          desc      : byte;
          limit2    : byte;
          base3     : byte;
    end;

    PTSS = ^NTSS;
    NTSS = record
          back_link, d_blh   : word;
          esp0               : pointer;
          ss0, d_ss0         : word;
          esp1               : dword;
          ss1, d_ss1         : word;
          esp2               : dword;

          ss2, d_ss2         : word;
          cr3, eip           : pointer;
          eflags,
          eax, ecx, edx, ebx : dword;
          esp, ebp           : pointer;
          esi, edi           : dword;
          es, d_es, cs, d_cs,
          ss, d_ss, ds, d_ds,
          fs, d_fs, gs, d_gs,
          ldt, d_ldt, trace,
          bitmap             : word;
   end;


const
     TP_REALTIME = 5;
     TP_HIGH     = 4;
     TP_NORMAL   = 3;
     TP_LOW      = 2;
     TP_LOWER    = 1;
     TP_IDLE     = 0;


{* External variables *}
var
    TSS_DESC_SEL: word; cvar; external;
    GDT:          PLongInt; cvar; external;
    CPR3_DATA:    word; cvar; external;
    CPR0_DATA:    word; cvar; external;


{* Exported variables *}
    current_task: PTask; cvar;
    tss:          PTSS; cvar;


{* Procedures and functions defined in this file *}
procedure init_sched;
procedure enablePIT( freq: word );
procedure disablePIT;

implementation

const
     PIT_FREQ = $1234DD;


{******************************************************************************
 *   enablePIT
 ******************************************************************************
 *   input:  how often (freq) the timer sends an int/per second
 *   output: %
 ******************************************************************************}
procedure enablePIT( freq: word ); [public, alias:'ENABLEPIT'];
var
   wIntFreq: word;
begin
     wIntFreq := PIT_FREQ div freq;

	// $36: channel 0, LSB/MSB, mode 3, binary
     poutb( $43, $36 ); // original: - $43, $74 -
	// $40: channel 0
     poutb( $40, wIntFreq mod 256);
     poutb( $40, wIntFreq div 256);
end;

{******************************************************************************
 *   disablePIT
 ******************************************************************************
 *  does:
 *   disables the PIT
 ******************************************************************************}
procedure disablePIT; [public, alias:'DISABLEPIT'];
begin
     poutb( $43, $7A );
     poutb( $40, 0);  // original: $41 instead of $40
     poutb( $40, 0);  // original: $41 instead of $40
end;

{******************************************************************************
 *   init_sched
 ******************************************************************************
 *  does:
 *   initializes multitasking
 ******************************************************************************}
procedure init_sched; [public, alias:'INIT_SCHED'];
var
   init_tss: PTSS_Desc;
   tmp:    word;
   tmp2:   Pointer;
begin
     init_tss := mem_alloc(sizeof(NTSS_Desc));
     init_tss^.limit1 := $67;
     init_tss^.desc   := $89;    { 10001001 }
     init_tss^.limit2 := 0;
     tmp := high(DWord(@TSS));
     init_tss^.base2 := high(tmp);
     init_tss^.base3 := low(tmp);
     init_tss^.base1 := low(DWord(@TSS));

     tmp2 := GDT + (tss_desc_sel * 8);
     mem_copy(init_tss, tmp2, sizeof(NTSS_Desc));
     free(init_tss);

     asm
        mov eax, cr3
        mov tmp2, eax
     end;
     TSS^.cr3 := tmp2;

     TSS^.ss := CPR3_DATA;
     TSS^.ss0 := CPR0_DATA;



//     set_interrupt($28, @pf_isr);
     enablePIT(100);
end;


begin
end.

